-- Create the database
CREATE DATABASE IF NOT EXISTS forum CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
USE forum;

-- Create the users table
CREATE TABLE IF NOT EXISTS users (
    id INT AUTO_INCREMENT PRIMARY KEY,
    username VARCHAR(50) NOT NULL,
    password VARCHAR(255) NOT NULL,
    full_name VARCHAR(100) NOT NULL
);

-- Create the categories table
CREATE TABLE IF NOT EXISTS categories (
    id INT AUTO_INCREMENT PRIMARY KEY,
    name VARCHAR(50) NOT NULL
);

-- Create the posts table
CREATE TABLE IF NOT EXISTS posts (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT NOT NULL,
    category_id INT NOT NULL,
    content TEXT NOT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (user_id) REFERENCES users(id),
    FOREIGN KEY (category_id) REFERENCES categories(id)
);

-- Insert initial data into users table
INSERT INTO users (username, password, full_name) VALUES
('anna', 'Ann123', 'Anna Kowalska'),
('jan', 'Jan123', 'Jan Nowak');

-- Insert initial data into categories table
INSERT INTO categories (name) VALUES
('Ogólne'),
('Specjalistyczne'),
('Techniczne'),
('Artystyczne'),
('Naukowe'),
('Hobby');

-- Insert initial data into posts table
INSERT INTO posts (user_id, category_id, content) VALUES
(1, 1, 'Czy ktoś zna dobry kurs programowania?'),
(2, 1, 'Tak, polecam kurs na Udemy!');
